* Definicia indexovych mnozin
Sets k index /1*6/
     m       /1*2/
     l       /GJM,ALT/;

    alias(m1,m);

* Definicia parameterov
Parameters x(k),z(k,m),q(k,m);
    x(k)=ord(k);

    z(k,'1')=0;
    z(k,'2')=1;

Parameter N1;
   N1=sum((k,m), 1);

   q(k,m)=1/N1;

Scalar y average,N5;
   y=1.5;
   N5=sum(m, 1);

Parameter N4(k);
   N4(k)=sum(m$(z(k,m) ne 0), 1);

* Definicia rovnic
Variables
   lambda
   eta
   gamma(k)
   N ;

Equations
     obj_gjm    define objective function
     obj_alt    define objective function;

obj_gjm..      N =e= y*lambda
                  + eta
                  - sum(k, log(sum(m, q(k,m)*exp(lambda*x(k)*z(k,m)+eta*z(k,m)))));
obj_alt..      N =e= y*lambda
                  + sum(k$(N4(k) = N5), gamma(k))
                  - log(sum((k,m)$(z(k,m) ne 0), z(k,m)*q(k,m)*exp(lambda*x(k)+(gamma(k)/z(k,m))$(N4(k) = N5))));

Model DiceGJM /obj_gjm/ ;
Model DiceALT /obj_alt/ ;

Parameter omega1(k),omega2,p(k,m),b(k,l),S1(k,l),S2(l);

eta.l = 0;
lambda.l = 0;
gamma.l(k) = 0;

* Optimalizacia a vypocet parametrov
solve DiceGJM using NLP maximizing N;

   omega1(k) = sum(m, q(k,m)*exp(lambda.l*x(k)*z(k,m)+eta.l*z(k,m)));
   p(k,m) = q(k,m)*exp(lambda.l*x(k)*z(k,m)+eta.l*z(k,m))/omega1(k);
   b(k,'GJM') = sum(m, z(k,m)*p(k,m));
   S1(k,'GJM') =-sum(m, p(k,m)*log(p(k,m))/log(N5));
   S2('GJM') = sum(k, S1(k,'GJM'))/6;

eta.l = 0;
lambda.l = 0;
gamma.l(k) = 0;

* Optimalizacia a vypocet parametrov
solve DiceALT using NLP maximizing N;

   omega2 = sum((k,m)$(z(k,m) ne 0), z(k,m)*q(k,m)*exp(lambda.l*x(k)+gamma.l(k)/z(k,m)));
   p(k,m)$(z(k,m) ne 0) = q(k,m)*exp(lambda.l*x(k)+gamma.l(k)/z(k,m) ) / omega2;
   p(k,m)$(z(k,m) = 0) = 1 - sum(m1$(z(k,m1) ne 0), p(k,m1));
   b(k,'ALT')=sum(m, z(k,m)*p(k,m));
   S1(k,'ALT') =-sum(m, p(k,m)*log(p(k,m))/log(N5));
   S2('ALT') = sum(k, S1(k,'ALT'))/6;

Display p,S1,S2,b;